#pragma once

/////////////////////////////////////////////////////////////////////////////
#ifdef COMMON_EXPORTS
	#define COMMON_API __declspec(dllexport)
#else
	#define COMMON_API __declspec(dllimport)
#endif
/////////////////////////////////////////////////////////////////////////////
#include "ShTarget.h"
#include "Service.h"
/////////////////////////////////////////////////////////////////////////////
#define		kSMSParamsDBFile		"SMSParams"
#define		kSMSParamsFolder		"./"
/////////////////////////////////////////////////////////////////////////////
// CConfigDlg dialog
class CService;
/////////////////////////////////////////////////////////////////////////////
class COMMON_API CServiceDlg : public CDialog
{
	DECLARE_DYNAMIC(CServiceDlg)

private:
	virtual int		GetIconId()		{ return NULL; };
public:
	CServiceDlg(UInt16 iDlgID, HINSTANCE iHInst, CService* iSvcP, void* iParamP=NULL);   // standard constructor	
	virtual ~CServiceDlg();
	virtual void			UpdateDisplay()=0;
	virtual char*			GetName()=0;
	virtual BOOL			ShowWindow( int nCmdShow );
	virtual BOOL			Apply()=0;
	// Extended dlg 
	virtual int				GetExtDlgCount()		{ return 0; };
	virtual CServiceDlg*	GetExtDlgUI(int iId)	{ return NULL; };
	virtual void			SetParam(void* iParamP)	{ resetPtr(mParamP); mParamP = iParamP; };
	//
	void					OnUpdate(int iItemChanged, int iAction);	
	void					OnUpdate(int iItemChanged, CDlgMsgParam* iParamP);	
	BOOL					Init(CWnd *iParentP);
	HICON					GetIcon();
	BOOL					IsExtended()			{ return mExtended; };
	void					SetId(int iId)			{ mId = iId; };
	//
	BOOL					mInited;
protected:
	HINSTANCE				mHInst;
	int						mDlgId;
	int						mId;		// used to identify dlg in the tree
	BOOL					mExtended;
	void*					mParamP;
	CService*				mServiceP;	
protected:
	virtual void			DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

	DECLARE_MESSAGE_MAP()
	afx_msg void			OnDestroy()			{ mInited = false; };
	afx_msg void			OnChange();
	// to prevent dialog closing on enter and esc key
	afx_msg void			OnOK();
	afx_msg void			OnCancel();
};
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////